using System;
using System.Linq;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        double epsilon = double.Parse(Console.ReadLine());

        var points = new List<(double x, double y)>();
        for (int i = 0; i < n; i++)
        {
            var coords = Console.ReadLine().Split().Select(double.Parse).ToArray();
            points.Add((coords[0], coords[1]));
        }

        var edges = new List<(int u, int v, double weight)>();
        for (int i = 0; i < n; i++)
        {
            for (int j = i + 1; j < n; j++)
            {
                double dist = Math.Abs(points[i].x - points[j].x) + Math.Abs(points[i].y - points[j].y);
                edges.Add((i + 1, j + 1, dist));
            }
        }

        var mstEdges = GetMST(edges, n);

        var selectedPoints = mstEdges.Select(e => e.u).Distinct().Take(18).ToList();

        Console.WriteLine(selectedPoints.Count);
        Console.WriteLine(string.Join(" ", selectedPoints));

        foreach (var edge in mstEdges)
        {
            if (selectedPoints.Contains(edge.u) && selectedPoints.Contains(edge.v))
            {
                Console.WriteLine($"{edge.u} {edge.v}");
            }
        }
    }

    static List<(int u, int v)> GetMST(List<(int u, int v, double weight)>, int n)
    {
        var mst = new List<(int u, int v)>();
        var uf = new UnionFind(n);

        var sortedEdges = edges.OrderBy(e => e.weight).ToList();

        foreach (var edge in sortedEdges)
        {
            if (uf.Union(edge.u - 1, edge.v - 1))
            {
                mst.Add((edge.u, edge.v));
            }
        }

        return mst;
    }
}

public class UnionFind
{
    private int[] parent;
    private int[] rank;

    public UnionFind(int n)
    {
        parent = Enumerable.Range(0, n).ToArray();
        rank = new int[n];
    }

    public int Find(int x)
    {
        if (parent[x] != x)
            parent[x] = Find(parent[x]);
        return parent[x];
    }

    public bool Union(int x, int y)
    {
        int rootX = Find(x);
        int rootY = Find(y);

        if (rootX == rootY) return false;

        if (rank[rootX] > rank[rootY])
            parent[rootY] = rootX;
        else if (rank[rootX] < rank[rootY])
            parent[rootX] = rootY;
        else
        {
            parent[rootY] = rootX;
            rank[rootX]++;
        }

        return true;
    }
}